#include "gl.h"
#include "gengine.h"
#include "..\common.h"

#define KEYBUFFER_TAIL	0xffffffff

extern LPDIRECTDRAW		lpDD;

LPDIRECTINPUT           lpDI			= NULL;
LPDIRECTINPUTDEVICE     lpDIKeyboard	= NULL;
LPDIRECTINPUTDEVICE		lpDIMouse		= NULL;
DIDEVICEOBJECTDATA		*lpDIKeyData	= NULL;
HANDLE					hDIThread, hDIExitEvent;
DWORD					hDIThreadid;

static DIDEVICEOBJECTDATA	*lpDIKeyDataTemp= NULL;
static BYTE keyState[256];	// ̵ǰ״̬ 

static DWORD WINAPI DInputManager( LPVOID tmp );

int InitDInput( HINSTANCE hInst )
{
	if( lpDD == NULL ){
		MsgBox( "init ddraw first" );
		return -1;
	}

	DWORD items = 0;
	DIPROPDWORD dipKb = {
		{	sizeof( DIPROPDWORD ),
			sizeof( DIPROPHEADER ),
			0,
			DIPH_DEVICE
		},
		KEYBUFFERSIZE 
	};
	if(( lpDIKeyData = new DIDEVICEOBJECTDATA[ KEYBUFFERSIZE ] ) == NULL ){
		MsgBox( "DInput allocate mem failed" );
		return -1;
	}
	if(( lpDIKeyDataTemp = new DIDEVICEOBJECTDATA[ KEYBUFFERSIZE ]) == NULL ){
		MsgBox( "DInput allocate mem failed" );
		delete lpDIKeyData;
		return -1;
	}
	if( FAILED( DirectInputCreate( hInst, DIRECTINPUT_VERSION, &lpDI, NULL ))){
		MsgBox( "Init DirectInput failed" );
		return -1;
	}
	if( FAILED( lpDI->CreateDevice( GUID_SysKeyboard, &lpDIKeyboard, NULL ))){
		MsgBox( "Create Keyboard device failed" );
		return -1;
	}
	if( FAILED( lpDIKeyboard->SetDataFormat( &c_dfDIKeyboard ))){
		MsgBox( "DInput SetFormat failed" );
		return -1;
	}
	if( FAILED( lpDIKeyboard->SetCooperativeLevel( hScreen, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND ))){
		MsgBox( "DI setcooperativelevel failed" );
		return -1;
	}
	if( FAILED( lpDIKeyboard->SetProperty( DIPROP_BUFFERSIZE, &dipKb.diph ))){
		MsgBox( "DI set keyb property failed" );
		return -1;
	}
	lpDIKeyboard->Acquire();
/*	if( SUCCESSED(lpDIKeyboard->GetDeviceData( sizeof( DIDEVICEOBJDECTDATA ), lpDIKeyData, &items, 0 ))){
		if( items < KEYBUFFERSIZE )
			lpDIKeyData[items].dwData = KEYBUFFER_TAIL;
		memcpy( lpDIKeyDataTemp, lpDIKeyData, sizeof( DIDEVICEOBJECTDATA )*KEYBUFFERSIZE );
	}*/
	//
	if( FAILED( lpDI->CreateDevice( GUID_SysMouse, &lpDIMouse, NULL ))){
		MsgBox( "豸ʧ." );
		return -1;
	}
	if( FAILED( lpDIMouse->SetDataFormat( &c_dfDIMouse ))){
		MsgBox( "DIMouse SetFormat failed" );
		return -1;
	}
#ifdef _DEBUG
	if( FAILED( lpDIMouse->SetCooperativeLevel( hScreen, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND ))){
#else
	if( FAILED( lpDIMouse->SetCooperativeLevel( hScreen, DISCL_EXCLUSIVE | DISCL_FOREGROUND ))){
#endif
		MsgBox( "DIMouse set cooperativelevel failed" );
		return -1;
	}
	lpDIMouse->Acquire();
	if( InitMouse() != 0 ){
		MsgBox( "InitMouse failed" );
		return -1;
	}

	hDIThread=CreateThread( NULL, 0, DInputManager, NULL , 0, &hDIThreadid );
	if ( hDIThread == NULL ){
		MsgBox( "create di thread failed" );
		return -1;
	}

	hDIExitEvent = CreateEvent( NULL,FALSE,FALSE,NULL );

	return 0;
}

void DestroyDInput( void )
{
	SetEvent( hDIExitEvent );
	if( lpDI ){
		if( lpDIKeyboard ){
			lpDIKeyboard->Unacquire();
			lpDIKeyboard->Release();
			lpDIKeyboard = NULL;
		}
		if( lpDIMouse ){
			lpDIMouse->Unacquire();
			lpDIMouse->Release();
			lpDIMouse = NULL;
		}
		lpDI = NULL;
	}
	MouseExit();
}

void DInputSync( int active )
{
	if( active ){
		if( lpDIKeyboard )
			lpDIKeyboard->Acquire();
		if( lpDIMouse )
			lpDIMouse->Acquire();
	}
	else{
		if( lpDIKeyboard )
			lpDIKeyboard->Unacquire();
		if( lpDIMouse )
			lpDIMouse->Unacquire();
	}
}

DWORD DInputReadkey( void )
{
	DWORD items = KEYBUFFERSIZE;
	if( FAILED( lpDIKeyboard->GetDeviceData( sizeof( DIDEVICEOBJECTDATA ), lpDIKeyData, &items, 0 ))){
		//OutDebugString( "dinputreadkey failed" );
		return 0;
	}
	//for( ; items>0; items-- ){
	//}
	//OutDebugInt( "di readkey items", items );
	if( items < KEYBUFFERSIZE )
		lpDIKeyData[items].dwData = KEYBUFFER_TAIL;
	if( items && lpDIKeyData[0].dwData & 0x80 )
		return lpDIKeyData[0].dwOfs;
	else
		return 0;
}

static DWORD WINAPI DInputManager( LPVOID tmp )
{
	for (;;) {
		Sleep(20);
		MouseTimerHandler( );

		if( WaitForSingleObject(hDIExitEvent, 0) == WAIT_OBJECT_0 )
			return 0;
	}
}

